<?php

namespace XCart\Extender\Tests\Action;

use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
use XCart\Extender\Action\FQNValidator;
use XCart\Extender\Action\Reflector;
use XCart\Extender\Action\ReflectorInterface;
use XCart\Extender\Exception\EntityException;
use XCart\Extender\Mapping\Extender\Mixin;
use XCart\Extender\Mapping\Extender\After;
use XCart\Extender\Mapping\Extender\Before;
use XCart\Extender\Mapping\Extender\Depend;
use XCart\Extender\Domain\EnabledModulesMap;
use XCart\Extender\Mapping\Extender\Rely;
use XCart\Extender\Model\Entity;
use XCart\Extender\Model\Reflection;
use XCart\Extender\Factory\ReflectionFactoryInterface;

/**
 * @covers \XCart\Extender\Action\FQNValidator
 */
class FQNValidatorTest extends TestCase
{
    /**
     * @param bool $expected
     * @param string $fqn
     *
     * @dataProvider getTestValidateProvider
     */
    public function testValidate(bool $expected, string $fqn): void
    {
        $fqnValidator = new FQNValidator();

        self::assertEquals($expected, $fqnValidator->validate($fqn));
    }

    public function getTestValidateProvider(): array
    {
        return [
            [true, 'Some\Name\Space\ClassName'],
            [false, 'Some\Name\Space\_.ClassName'],
        ];
    }
}
