<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Model;

use Symfony\Contracts\EventDispatcher\Event;

class EntityEvent extends Event
{
    /**
     * @var Entity
     */
    private Entity $entity;

    /**
     * @var array|null
     */
    private ?array $result = null;

    /**
     * @param Entity $entity
     */
    public function __construct(Entity $entity)
    {
        $this->entity = $entity;
    }

    /**
     * @return Entity
     */
    public function getEntity(): Entity
    {
        return $this->entity;
    }

    /**
     * @param Entity $entity
     */
    public function setEntity(Entity $entity): void
    {
        $this->entity = $entity;
    }

    /**
     * @return array|null
     */
    public function getResult(): ?array
    {
        return $this->result;
    }

    /**
     * @param array|null $result
     */
    public function setResult(?array $result): void
    {
        $this->result = $result;
    }
}
