<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Mapping\Extender;

use function is_array;
use function strpos;
use function substr;

/**
 * @Annotation
 * @codeCoverageIgnore
 */
class Rely
{
    /**
     * @var array
     */
    public array $dependencies = [];

    /**
     * @var array
     */
    public array $incompatibilities = [];

    /**
     * @param array|string $param
     */
    public function __construct($param)
    {
        $params = is_array($param['value']) ? $param['value'] : [$param['value']];

        foreach ($params as $value) {
            if (strpos($value, '!') === 0) {
                $this->incompatibilities[] = substr($value, 1);
            } else {
                $this->dependencies[] = $value;
            }
        }
    }
}
