<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Factory;

use XCart\Extender\Exception\EntityException;
use XCart\Extender\Model\Entity;
use XCart\Extender\Model\Reflection;

class ReflectionFactoryCached implements ReflectionFactoryInterface
{
    /**
     * @var ReflectionFactoryInterface
     */
    private ReflectionFactoryInterface $reflectionFactory;

    /**
     * @var array
     */
    private array $cache = [];

    /**
     * @param ReflectionFactoryInterface $reflectionFactory
     */
    public function __construct(
        ReflectionFactoryInterface $reflectionFactory
    ) {
        $this->reflectionFactory = $reflectionFactory;
    }

    /**
     * @param Entity $entity
     *
     * @return Reflection
     * @throws EntityException
     */
    public function build(Entity $entity): Reflection
    {
        $fqn = $entity->getFqn();
        if (!isset($this->cache[$fqn])) {
            $this->cache[$fqn] = $this->reflectionFactory->build($entity);
        }

        return $this->cache[$fqn];
    }
}
