<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Factory;

use XCart\Extender\Exception\LogicException;
use XCart\Extender\Model\Entity;

class EntityFactoryCached implements EntityFactoryInterface
{
    /**
     * @var EntityFactoryInterface
     */
    private EntityFactoryInterface $entityFactory;

    /**
     * @var array
     */
    private array $cache = [];

    /**
     * @param EntityFactoryInterface $entityFactory
     */
    public function __construct(EntityFactoryInterface $entityFactory)
    {
        $this->entityFactory = $entityFactory;
    }

    /**
     * @param string $fqn
     * @param string $sourcePath
     *
     * @return Entity
     * @throws LogicException
     */
    public function build(string $fqn, string $sourcePath = ''): Entity
    {
        if (!isset($this->cache[$fqn])) {
            $this->cache[$fqn] = $this->entityFactory->build($fqn, $sourcePath);
        }

        return $this->cache[$fqn];
    }

    /**
     * @param Entity $entity
     *
     * @return Entity
     */
    public function buildAncestor(Entity $entity): Entity
    {
        return $this->entityFactory->buildAncestor($entity);
    }

    /**
     * @param Entity $entity
     *
     * @return Entity
     */
    public function buildDescendant(Entity $entity): Entity
    {
        return $this->entityFactory->buildDescendant($entity);
    }
}
