<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Exception;

use Exception;

class LogicException extends Exception
{
    /**
     * @param Exception $exception
     *
     * @return static
     */
    public static function fromMixinSorting(Exception $exception): self
    {
        return new self('Mixins sorting error', $exception->getCode(), $exception);
    }

    /**
     * @param string $fqn
     *
     * @return static
     */
    public static function fromEmptySourcePath(string $fqn): self
    {
        return new self("Source path is empty for {$fqn}");
    }
}
