<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Event;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use XCart\Extender\Factory\CodeFileFactory;
use XCart\Extender\Model\EntityEvent;

class ApiPlatformSubscriber implements EventSubscriberInterface
{
    /**
     * @var CodeFileFactory
     */
    private CodeFileFactory $codeFileFactory;

    /**
     * @param CodeFileFactory $codeFileFactory
     */
    public function __construct(
        CodeFileFactory $codeFileFactory
    ) {
        $this->codeFileFactory = $codeFileFactory;
    }

    /**
     * @return string[]
     */
    public static function getSubscribedEvents(): array
    {
        return [
            'build-ancestor-from-source' => 'onBuildAncestorFromSource',
        ];
    }

    /**
     * @param EntityEvent $event
     */
    public function onBuildAncestorFromSource(EntityEvent $event): void
    {
        $this->codeFileFactory->addRemoveAnnotationMutation(
            $event->getEntity(),
            [
                'ApiPlatform\\\\ApiResource',
                'ApiPlatform\\\\ApiFilter',
                'ApiResource',
                'ApiFilter',
            ]
        );
    }
}
