<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Domain;

use function array_map;
use function str_replace;

class ModuleDependenciesMap extends HashMapAbstract
{
    /**
     * @param array $hashMap
     */
    public function setHashMap(array $hashMap): void
    {
        foreach ($hashMap as $key => $value) {
            $this->offsetSet(
                str_replace('-', '\\', $key),
                array_map(static function ($item) {
                    return str_replace('-', '\\', $item);
                }, $value)
            );
        }
    }
}
