<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\CodeGenerator;

use function count;
use function in_array;
use function is_array;

use const T_CLASS;
use const T_INTERFACE;
use const T_STRING;
use const T_TRAIT;

class NameMutation implements MutationInterface
{
    /**
     * @var string
     */
    private string $name;

    /**
     * @param string $name
     */
    public function __construct(string $name)
    {
        $this->name = $name;
    }

    /**
     * @param int|string $token
     * @param string     $content
     *
     * @return bool
     */
    public function isAnchor($token, string $content): bool
    {
        return in_array($token, [T_CLASS, T_INTERFACE, T_TRAIT], true);
    }

    /**
     * @param array $tokens
     * @param int   $anchorPosition
     *
     * @return array
     */
    public function getSubstitutions(array $tokens, int $anchorPosition): array
    {
        $result = [];

        $count = count($tokens);
        while ($anchorPosition < $count) {
            $token = $tokens[$anchorPosition];
            [$token] = is_array($token) ? $token : [$token];

            if ($token === T_STRING) {
                $result[$anchorPosition] = $this->name;

                break;
            }

            $anchorPosition++;
        }

        return $result;
    }
}
