<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\CodeGenerator;

use Closure;

use function in_array;
use function is_array;

use const T_CLASS;
use const T_DOC_COMMENT;
use const T_INTERFACE;
use const T_TRAIT;

class DocCommentMutation implements MutationInterface
{
    /**
     * @var Closure
     */
    private Closure $replaceFunc;

    /**
     * @param Closure $replaceFunc
     */
    public function __construct(Closure $replaceFunc)
    {
        $this->replaceFunc = $replaceFunc;
    }

    /**
     * @param int|string $token
     * @param string     $content
     *
     * @return bool
     */
    public function isAnchor($token, string $content): bool
    {
        return in_array($token, [T_CLASS, T_INTERFACE, T_TRAIT], true);
    }

    /**
     * @param array $tokens
     * @param int   $anchorPosition
     *
     * @return array
     */
    public function getSubstitutions(array $tokens, int $anchorPosition): array
    {
        $result = [];

        while ($anchorPosition >= 0) {
            $token = $tokens[$anchorPosition];
            [$token, $content] = is_array($token) ? $token : [$token, $token];

            if ($token === ';') {
                break;
            }

            if ($token === T_DOC_COMMENT) {
                $result[$anchorPosition] = ($this->replaceFunc)($content);

                break;
            }

            $anchorPosition--;
        }

        return $result;
    }
}
