<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Autoloader\Development;

use XCart\Extender\Domain\SourceMapInterface;
use XCart\Extender\Domain\TargetMap;

interface StreamFilterInterface
{
    /**
     * @param StreamWrapper $streamWrapper
     */
    public static function setWrapper(StreamWrapper $streamWrapper): void;

    /**
     * @param SourceMapInterface $sourceMap
     */
    public static function setSourceMap(SourceMapInterface $sourceMap): void;

    /**
     * @param TargetMap $targetMap
     */
    public static function setTargetMap(TargetMap $targetMap): void;
}
