<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action;

use Symfony\Component\Filesystem\Exception\IOException;
use Symfony\Component\Filesystem\Filesystem;
use XCart\Extender\Exception\EntityException;
use XCart\Extender\Model\Entity;

class Writer
{
    /**
     * @var Filesystem
     */
    private Filesystem $filesystem;

    /**
     * @param Filesystem $filesystem
     */
    public function __construct(
        Filesystem $filesystem
    ) {
        $this->filesystem = $filesystem;
    }

    /**
     * @param Entity $entity
     * @param string $content
     *
     * @throws EntityException
     */
    public function write(Entity $entity, string $content): void
    {
        try {
            $this->filesystem->dumpFile($entity->getTargetPath(), $content);
        } catch (IOException $exception) {
            throw EntityException::fromWriteSource($entity, $exception);
        }
    }
}
