<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action\ViewListReader;

use XCart\Extender\Exception\EntityException;
use XCart\Extender\Model\Entity;

class ViewListExtractorCached implements ViewListExtractorInterface
{
    /**
     * @var ViewListExtractorInterface
     */
    private ViewListExtractorInterface $viewListExtractor;

    /**
     * @var array
     */
    private array $cache;

    /**
     * @param ViewListExtractorInterface $viewListExtractor
     */
    public function __construct(
        ViewListExtractorInterface $viewListExtractor
    ) {
        $this->viewListExtractor = $viewListExtractor;
    }

    /**
     * @param Entity $entity
     *
     * @return array
     * @throws EntityException
     */
    public function read(Entity $entity): array
    {
        $fqn = $entity->getFqn();
        if (!isset($this->cache[$fqn])) {
            $this->cache[$fqn] = $this->viewListExtractor->read($entity);
        }

        return $this->cache[$fqn];
    }
}
