<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action;

use XCart\Extender\Exception\IOException;

class ReaderCached implements ReaderInterface
{
    /**
     * @var ReaderInterface
     */
    private ReaderInterface $reader;

    /**
     * @var array
     */
    private array $cache = [];

    /**
     * @param ReaderInterface $reader
     */
    public function __construct(
        ReaderInterface $reader
    ) {
        $this->reader = $reader;
    }

    /**
     * @param string $sourcePath
     *
     * @return string
     * @throws IOException
     */
    public function readSource(string $sourcePath): string
    {
        if (!isset($this->cache[$sourcePath])) {
            $this->cache[$sourcePath] = $this->reader->readSource($sourcePath);
        }

        return $this->cache[$sourcePath];
    }
}
