<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action;

use XCart\Extender\Exception\IOException;

use function file_get_contents;
use function is_readable;

class Reader implements ReaderInterface
{
    /**
     * @param string $sourcePath
     *
     * @return string
     * @throws IOException
     */
    public function readSource(string $sourcePath): string
    {
        if (is_readable($sourcePath)) {
            return file_get_contents($sourcePath);
        }

        throw IOException::fromReadSource($sourcePath);
    }
}
