<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action;

use Doctrine\Common\Annotations\AnnotationException;
use Doctrine\Common\Annotations\DocParser;
use ReflectionException;
use XCart\Extender\Model\Reflection;

class ImportedAnnotationsParser implements AnnotationsParserInterface
{
    /**
     * @var DocParser
     */
    private DocParser $docParser;

    /**
     * @param DocParser $docParser
     *
     * @codeCoverageIgnore
     */
    public function __construct(
        DocParser $docParser
    ) {
        $docParser->setIgnoreNotImportedAnnotations(true);

        $this->docParser = $docParser;
    }

    /**
     * @param Reflection $reflection
     *
     * @return array
     * @throws AnnotationException
     * @throws ReflectionException
     */
    public function parseAnnotations(Reflection $reflection): array
    {
        $this->docParser->setImports($reflection->getImports());

        return $this->docParser->parse($this->hideAnnotations($reflection->getDocComment()));
    }

    private function hideAnnotations(string $docComment): string
    {
        if (strpos($docComment, 'ApiFilter') === false) {
            return $docComment;
        }

        $annotations = [
            'ApiFilter',
            'ApiPlatform\\\\ApiFilter',
        ];

        foreach ($annotations as $annotation) {
            $docComment = preg_replace("/@({$annotation}\b)/i", ' $1', $docComment);
        }

        return $docComment;
    }
}
