<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action\ClassCacheBuilder;

use XCart\Extender\Domain\TargetStreamMap;
use XCart\Extender\Exception\EntityException;
use XCart\Extender\Exception\LogicException;
use XCart\Extender\Model\Entity;

class ChainBuilderCached implements ChainBuilderInterface
{
    /**
     * @var ChainBuilderInterface
     */
    private ChainBuilderInterface $chainBuilder;

    /**
     * @var TargetStreamMap
     */
    private TargetStreamMap $targetStreamMap;

    /**
     * @param ChainBuilderInterface $chainBuilder
     * @param TargetStreamMap       $targetStreamMap
     */
    public function __construct(
        ChainBuilderInterface $chainBuilder,
        TargetStreamMap $targetStreamMap
    ) {
        $this->chainBuilder    = $chainBuilder;
        $this->targetStreamMap = $targetStreamMap;
    }

    /**
     * @param string $fqn
     * @param Entity $entity
     *
     * @return array
     * @throws EntityException
     * @throws LogicException
     */
    public function buildChain(string $fqn, Entity $entity): array
    {
        if (!isset($this->targetStreamMap[$fqn])) {
            $this->targetStreamMap->merge($this->chainBuilder->buildChain($fqn, $entity));
        }

        return [$fqn => $this->targetStreamMap[$fqn] ?? ''];
    }
}
