<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action\ClassCacheBuilder;

use XCart\Extender\Exception\EntityException;
use XCart\Extender\Exception\LogicException;

interface BuilderInterface
{
    /**
     * @param string $fqn
     * @param string $sourcePath
     *
     * @return string
     * @throws EntityException
     * @throws LogicException
     */
    public function buildByFQN(string $fqn, string $sourcePath = ''): string;

    /**
     * @param string $sourcePath
     *
     * @return string
     * @throws EntityException
     * @throws LogicException
     */
    public function buildByPath(string $sourcePath): string;
}
