<?php

require_once '../vendor/autoload.php';

$targetStreamMap = new \XCart\Extender\Domain\TargetStreamMap();

try {
    $cache = json_decode(file_get_contents(__DIR__ . '/static-cache.data'), true, 512, JSON_THROW_ON_ERROR);

    $targetStreamMap->setHashMap($cache);

    $autoloader = new \XCart\Extender\Autoloader\StaticAutoloader($targetStreamMap);
    $autoloader->register();

    $class1 = new XLite\Class1();

    echo $class1->ping();
    echo "\n";
} catch (JsonException $e) {
    echo "{$e->getMessage()}\n";
}
