<?php

require_once '../vendor/autoload.php';

use Symfony\Component\Yaml\Yaml;
use XCart\Extender\Autoloader\DevelopmentAutoloader;
use XCart\Extender\Extender;

$modules = [
    'XC\Module1',
    'XC\Module2',
];

$dependencies = [];

$root    = __DIR__ . '/input/';

$sources = ['XLite' => $root . 'XLite'];

foreach (glob($root . 'XLite/Module/*/*') as $path) {
    $namespace = str_replace([$root, '/'], ['', '\\'], $path);

    [, , $author, $name] = explode('\\', $namespace);
    $module = implode('\\', [$author, $name]);

    if (in_array($module, $modules, true)) {
        $sources[$namespace] = $path;
    }

    $moduleInfo = Yaml::parse(
        file_get_contents($path . '/main.yaml')
    );

    $dependencies[$module] = $moduleInfo['dependsOn'];
}

$extender = new Extender();

$extender
    ->setSources($sources)
    ->setTargetRoot(__DIR__ . '/output/')
    ->setModules($modules)
    ->setDependencies($dependencies)
    ->addSubscribers()
    ->setDeveloperMode();

$sourceMap = $extender->getSourceMap();
$builder   = $extender->getBuilder();

$autoloader = new DevelopmentAutoloader(
    $builder,
    $sourceMap
);
$autoloader->register();

$class1 = new XLite\Class1();

echo $class1->ping();
echo "\n";
