<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Validation;
use Symfony\Component\Validator\Validator\ValidatorInterface;

class Validator
{
    /**
     * Validator
     *
     * @var ValidatorInterface
     */
    private ValidatorInterface $validator;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->validator = Validation::createValidator();
    }

    /**
     * Validate data against schema and return an array of error messages
     *
     * @param array                  $data   Data to validate
     * @param Assert\Collection|null $schema Validation schema
     *
     * @return string[]
     */
    public function validate(array $data, ?Constraint $schema = null, $root = null): array
    {
        $violations = $this->validator->validate($data, $schema);

        $errors = [];

        foreach ($violations as $violation) {
            $errors[] = sprintf('%s%s: %s', $root ?: 'Array', $violation->getPropertyPath(), $violation->getMessage());
        }

        return $errors;
    }
}
