<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class GetVersionInfo extends ARequest
{
    protected string $target = 'get_version_info';

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'entities' => new Assert\All([
                new Assert\Collection([
                    'author' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]/']),
                    'name' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]/']),
                    'versionFrom' => new Assert\Regex(['pattern' => '/(\d+\.\d+)\.(\d+)\.?(\d+)?/']),
                    'versionTo' => new Assert\Regex(['pattern' => '/(\d+\.\d+)\.(\d+)\.?(\d+)?/']),
                    'infoType' => new Assert\Optional([
                        new Assert\All([
                            new Assert\Type('string'),
                        ])
                    ]),
                ]),
            ]),
        ]);
    }

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\All([
            new Assert\Collection([
                'fields' => [
                    'author' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]/']),
                    'name' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]/']),
                ],
                'allowExtraFields' => true,
            ]),
        ]);
    }
}
