<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class GetShippingMethods extends ARequest
{
    protected string $target = 'get_shipping_methods';

    protected int $cacheTTL = self::TTL_LONG;

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return null;
    }

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'addons' => [
                new Assert\Type('array'),
                new Assert\Count(['min' => 0]),
                new Assert\All([
                    new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]+-[a-zA-Z0-9_]+/']),
                ]),
            ],
            'processors' => [
                new Assert\Type('array'),
                new Assert\Count(['min' => 0]),
                new Assert\All([
                    new Assert\Collection([
                        'processor' => new Assert\Type('string'),
                        'carrier' => new Assert\Type('string'),
                        'code' => new Assert\Type('string'),
                        'enabled' => new Assert\Range(['min' => 0, 'max' => 1]),
                        'added' => new Assert\Range(['min' => 0, 'max' => 1]),
                        'position' => new Assert\PositiveOrZero(),
                        'fromMarketplace' => new Assert\Range(['min' => 0, 'max' => 1]),
                        'moduleName' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]+_[a-zA-Z0-9_]+/']),
                        'translations' => [
                            new Assert\Type('array'),
                            new Assert\Count(['min' => 0]),
                            new Assert\All([
                                new Assert\Collection([
                                    'code' => new Assert\Type('string'),
                                    'name' => new Assert\Type('string'),
                                ]),
                            ]),
                        ],
                        'iconURL' => new Assert\Url(),
                    ]),
                ]),
            ],
        ]);
    }
}
