<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class GetEditions extends ARequest
{
    protected string $target = 'get_editions';

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\All([
            new Assert\Collection([
                'name' => new Assert\Type('string'),
                'xb_product_id' => new Assert\PositiveOrZero(),
                'is_cloud' => new Assert\Range(['min' => 0, 'max' => 1]),
                'description' => new Assert\Type('string'),
                'price' => new Assert\Type('string'),
                'avail_for_sale' => new Assert\Range(['min' => 0, 'max' => 1]),
                'xcnPlan' => new Assert\PositiveOrZero(),
                'stripe_product_id' => new Assert\Optional([
                    new Assert\Type('string'),
                ]),
            ]),
        ]);
    }
}
