<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class GetCores extends ARequest
{
    protected string $target = 'get_cores';

    protected int $cacheTTL = self::TTL_LONG;

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\All([
            new Assert\Collection([
                'version' => new Assert\Collection([
                    'major' => new Assert\Regex(['pattern' => '/^\d+\.\d+$/']),
                    'minor' => new Assert\PositiveOrZero(),
                    'build' => new Assert\PositiveOrZero(),
                ]),
                'revisionDate' => new Assert\Positive(),
                'length' => new Assert\PositiveOrZero(),
                'wave' => new Assert\GreaterThanOrEqual(['value' => -10]),
                'docs' => new Assert\Optional([
                    new Assert\Type('array'),
                    new Assert\Count(['min' => 0]),
                ]),
            ]),
        ]);
    }
}
