<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class GetAllTags extends ARequest
{
    protected string $target = 'get_all_tags';

    protected int $cacheTTL = self::TTL_LONG;

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\All([
            new Assert\Collection([
                'tag_name' => new Assert\Type('string'),
                'tag_banner_expiration_date' => new Assert\Type('string'), // e.g. Wed, 15 May 2019 00:00:00 +0400
                'tag_banner_img' => new Assert\Url(),
                'tag_module_banner' => new Assert\Optional([
                    new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]+-[a-zA-Z0-9_]+/']),
                ]),
                'tag_banner_url' => new Assert\Url(),
                'category' => new Assert\Choice(['M', 'T']),
            ]),
        ]);
    }
}
