<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class GetAddonPack extends AGetPack
{
    protected string $target = 'get_addon_pack';

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'fields' => [
                'moduleId' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9]/']),
                'key' => new Assert\Optional([
                    new Assert\Type('string'),
                ]),
                'gzipped' => new Assert\Optional([
                    new Assert\Range(['min' => 0, 'max' => 1]),
                ]),
                'xcn_license_key'=> new Assert\Optional([
                    new Assert\Type('string'),
                ]),
            ],
        ]);
    }
}
