<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class CreateStoreIdentity extends ARequest
{
    protected string $target = 'create_store_identity';

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'modules' => new Assert\Required([
                new Assert\Type('array'),
                new Assert\All([
                    new Assert\Collection([
                        'author'  => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]/']),
                        'name'    => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]/']),
                        'major'   => new Assert\Regex(['pattern' => '/^\d+\.\d+$/']),
                        'minor'   => new Assert\PositiveOrZero(),
                        'build'   => new Assert\PositiveOrZero(),
                        'enabled' => new Assert\Type(['type' => 'bool']),
                    ]),
                ]),
            ]),

            'addonsLicenses' => [
                new Assert\Type('array'),
                new Assert\Count(['min' => 0]),
                new Assert\All([
                    new Assert\Type(['type' => 'string']),
                ]),
            ],
            'addonsTokens'   => [
                new Assert\Type('array'),
                new Assert\Count(['min' => 0]),
                new Assert\All([
                    new Assert\Type(['type' => 'string']),
                ]),
            ],
            'dependencyMap'  => new Assert\Optional([
                new Assert\Type('array'),
                new Assert\Count(['min' => 0]),
            ]),
            'adminURL'       => new Assert\Required([
                new Assert\Url(),
            ]),
            'public_key'     => new Assert\Required([
                new Assert\Type(['type' => 'string']),
            ]),
            'wave'           => new Assert\Optional([
                new Assert\Range(['min' => -10, 'max' => 127]),
            ]),
            'trial'          => new Assert\Optional([
                new Assert\PositiveOrZero(),
            ]),
        ]);
    }

    /**
     * Get response validation schema
     *
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\Collection([new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]/'])]);
    }
}
