<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class CheckAddonKey extends ARequest
{
    protected string $target = 'check_addon_key';

    protected int $cacheTTL = 0;

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'key' => [], // string or string[]
            'doRegister' => new Assert\Optional([
                new Assert\EqualTo(1),
            ]),
            'wave' => new Assert\Optional([
                new Assert\Range(['min' => -10, 'max' => 127]),
            ]),
            'withModulesVersionInfo' => new Assert\Optional([
                new Assert\EqualTo(1),
            ]),
            'withCoresVersionInfo' => new Assert\Optional([
                new Assert\EqualTo(1),
            ]),
        ]);
    }

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\All([
            new Assert\All([
                new Assert\Collection([
                    'fields' => [
                        'author' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]/']),
                        'name' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]/']),
                        'keyType' => new Assert\Optional([
                            new Assert\Regex(['pattern' => '/[02]/']), // 0 - addon, 2 - core [1 - batch (is not supported)]
                        ]),
                        'xcnPlan' => new Assert\Optional([
                            new Assert\GreaterThanOrEqual(['value' => -1]),
                        ]),
                        'keyData' => new Assert\Collection([
                            'editionName' => new Assert\Optional([
                                new Assert\Type('string'),
                            ]),
                            'expDate' => new Assert\PositiveOrZero(),
                            'message' => new Assert\Optional([
                                new Assert\Type('string'),
                            ]),
                            'prolongKey' => new Assert\Type('int'),
                            'xbProductId' => new Assert\Optional([
                                new Assert\Type('string'),
                            ]),
                            'wave' => new Assert\Range(['min' => -10, 'max' => 127]),
                        ]),
                        'key' => [],
                        'modules' => new Assert\Optional([
                            new Assert\All([
                                GetAddonInfo::getResponseValidationSchema(),
                            ]),
                        ]),
                        'cores' => new Assert\Optional([
                            GetCores::getResponseValidationSchema(),
                        ]),
                    ],
                ]),
            ]),
        ]);
    }
}
