<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class ChangeKeyWave extends ARequest
{
    protected string $target = 'change_key_wave';

    /**
     * Flag: true to use cache to store response
     *
     * @var bool
     */
    protected bool $useCache = false;

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'fields' => [
                'wave' => new Assert\Range(['min' => -10, 'max' => 127]),
                'keys' => [
                    new Assert\Type('array'),
                    new Assert\Count(['min' => 1]),
                    new Assert\All([
                        new Assert\Type('string'),
                    ]),
                ],
            ],
        ]);
    }

    /**
     * Get request cache key
     *
     * @return bool
     */
    public function isIgnoreCache(): bool
    {
        return true;
    }
}
