<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class AddonsSearch extends ARequest
{
    protected string $target = 'addons_search';

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'fields' => [
                'substring' => new Assert\Type('string'),
            ],
        ]);
    }

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'numFoundProducts' => new Assert\PositiveOrZero(),
            'resultsFor' => new Assert\Optional([
                new Assert\Type('string'),
            ]),
            'products' => [
                new Assert\Type('array'),
                new Assert\Count(['min' => 0]),
            ],
        ]);
    }
}
