# X-Cart marketplace connector

X-Cart marketplace connector is a PHP client that allows to send requests to X-Cart marketplace.

## Installing

The recommended way to install X-Cart marketplace connector is through
[Composer](https://getcomposer.org/).

```bash
composer require xcart/marketplace-connector
```

## Usage

The specification of requests input data can be found [here](src/Request/)

See the usage example below:

```
// Prepare logger
$logger = new \Monolog\Logger('mx-conn');
$logger->pushHandler(new \Monolog\Logger(ROOT_DIR . '/var/logs/myapp.log', \Monolog\Logger::DEBUG));

// Prepare cache
$cache = new Symfony\Component\Cache\Adapter\FilesystemAdapter('mx_conn', 0, ROOT_DIR . '/var/cache');

// Prepare configuration
$config = new \XCartMarketplace\Connector\Config([
    'url' => 'https://my.x-cart.com/api/',
    'shopID' => md5('test store'),
    'shopDomain' => 'xcart.example.com',
    'shopURL' => 'http://xcart.example.com',
    'currentCoreVersion' => [
        'major' => '5.4',
        'minor' => 1,
        'build' => 30,
    ],
	// Both options below are optional
    // 'xcn_license_key' => 'key',
	// 'customer_id' => '100'
    'installation_lng' => 'en',
    'shopCountryCode' => 'US',
    'affiliateId' => '',
    'trial' => true,
    'cloud' => false,
]);

$config->setOption('email', 'admin@example.com');

// Create client
$client = new \XCartMarketplace\Connector\Client($config, $cache, $logger);

// Add some requests
$client->addRequest('get_waves');
$client->addRequest('get_sections');
$client->addRequest('get_editions');
$client->addRequest(
    'get_addon_pack',
    [
        'moduleId' => '187a5c222a7ee61e1ccf2768be0e9d0e',
        'gzipped' => 1,
    ],
    true,
    [
        'range' => '0-1',
    ]
);

try {
    // Send requests
    $responses = $client->getData();

    foreach ($responses as $requestType => $response) {
	    // Process response for specific request type, e.g.
		// processResponse($requestType, $response);
    }

} catch (\XCartMarketplace\Connector\Exceptions\RequestValidationException $e) {
    // Process exception...

} catch (\XCartMarketplace\Connector\Exceptions\ClientException $e) {
    // Process exception...
}
```

## License

Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
See https://www.x-cart.com/license-agreement.html for license details.
