<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle;

use Symfony\Component\DependencyInjection\Compiler\PassConfig;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Bundle\Bundle;
use XCart\Bundle\LogicBundle\DependencyInjection\Compiler\CreateClassNameValidatorsPass;
use XCart\Bundle\LogicBundle\DependencyInjection\Compiler\CreateRequestFactoriesPass;
use XCart\Bundle\LogicBundle\DependencyInjection\Compiler\CreateResponseFactoriesPass;
use XCart\Bundle\LogicBundle\DependencyInjection\Compiler\CreateValidatorsPass;
use XCart\Bundle\LogicBundle\DependencyInjection\Compiler\DetectActionRequestPass;
use XCart\Bundle\LogicBundle\DependencyInjection\Compiler\DetectActionResponsePass;

class LogicBundle extends Bundle
{
    public function build(ContainerBuilder $container): void
    {
        parent::build($container);

        $container->addCompilerPass(new DetectActionRequestPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 100);
        $container->addCompilerPass(new DetectActionResponsePass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 100);
        $container->addCompilerPass(new CreateRequestFactoriesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 90);
        $container->addCompilerPass(new CreateResponseFactoriesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 90);
        $container->addCompilerPass(new CreateClassNameValidatorsPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 80);
        $container->addCompilerPass(new CreateValidatorsPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 80);
    }
}
