<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Factory\Response;

use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class ResponseFactory implements ResponseFactoryInterface
{
    public function __construct(
        private string $className,
    ) {
    }

    public function create(): ResponseInterface
    {
        return new $this->className();
    }
}
