<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Enum\FilterStrategy;

use MyCLabs\Enum\Enum;

/**
 * This method name format is required by myclabs/php-enum library
 * @method static EXACT()
 * @method static PARTIAL()
 * @method static START()
 * @method static END()
 * @method static WORD_START()
 */
class StringFilterStrategyType extends Enum implements FilterStrategyInterface
{
    /**
     * @var string Exact matching
     */
    public const EXACT = 'exact';

    /**
     * @var string The value must be contained in the field
     */
    public const PARTIAL = 'partial';

    /**
     * @var string Finds fields that are starting with the value
     */
    public const START = 'start';

    /**
     * @var string Finds fields that are ending with the value
     */
    public const END = 'end';

    /**
     * @var string Finds fields that are starting with the word
     */
    public const WORD_START = 'word_start';
}
