<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Enum\FilterStrategy;

use MyCLabs\Enum\Enum;

/**
 * This method name format is required by myclabs/php-enum library
 * @method static INCLUDE_BOTH()
 * @method static INCLUDE_BEGIN()
 * @method static INCLUDE_END()
 */
class RangeFilterStrategyType extends Enum implements FilterStrategyInterface
{
    /**
     * @var string The field must match one of the filter values
     */
    public const INCLUDE_BOTH = 'both';

    /**
     * @var string The field must match one of the filter values partially
     */
    public const INCLUDE_BEGIN = 'begin';

    /**
     * @var string The field must match the filter values partially
     */
    public const INCLUDE_END = 'end';
}
