<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Enum\FilterStrategy;

use MyCLabs\Enum\Enum;

/**
 * This method name format is required by myclabs/php-enum library
 * @method static IN()
 * @method static PARTIAL_OR()
 * @method static PARTIAL_ALL()
 */
class ListFilterStrategyType extends Enum implements FilterStrategyInterface
{
    /**
     * @var string The field must match one of the filter values
     */
    public const IN = 'in';

    /**
     * @var string The field must match all the filter values
     */
    public const ALL_IN = 'all_in';
}
