<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\DependencyInjection;

use Exception;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use XCart\Bundle\LogicBundle\Action\ActionInterface;

class LogicExtension extends Extension
{
    public const ACTION_TAG = 'xcart.logic.action';

    /**
     * @throws Exception
     */
    public function load(array $configs, ContainerBuilder $container): void
    {
        $loader = new YamlFileLoader(
            $container,
            new FileLocator(__DIR__ . '/../Resources/config')
        );
        $loader->load('factories.yaml');
        $loader->load('decorator/validator.yaml');
        $loader->load('action/workflow.yaml');

        $container->registerForAutoconfiguration(ActionInterface::class)
            ->addTag(self::ACTION_TAG);
    }
}
