<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use XCart\Bundle\LogicBundle\DependencyInjection\Compiler\DataProvider\ActionDataProvider;
use XCart\Bundle\LogicBundle\DependencyInjection\Compiler\Parser\ActionParser;
use XCart\Bundle\LogicBundle\DependencyInjection\LogicExtension;

class DetectActionResponsePass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $actionDataProvider = new ActionDataProvider($container);
        $actionParser = new ActionParser();

        foreach ($actionDataProvider->getActions() as $service) {
            $tag = $service->getTag(LogicExtension::ACTION_TAG);
            if (!empty($tag[0]) && !empty($tag[0]['response'])) {
                continue;
            }

            $classes = $actionParser->getReturnClasses($service->getClass());
            if (!$classes) {
                continue;
            }

            $tags = $service->getTags();
            $tags[LogicExtension::ACTION_TAG][0]['response'] = $classes[0];
            $service->setTags($tags);

            if (!isset($classes[1])) {
                continue;
            }

            $tags = $service->getTags();
            $tags[LogicExtension::ACTION_TAG][0]['failed_response'] = $classes[1];
            $service->setTags($tags);
        }
    }
}
