<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\DependencyInjection\Compiler\DataProvider;

use Generator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use XCart\Bundle\LogicBundle\DependencyInjection\LogicExtension;

class ActionDataProvider
{
    public function __construct(
        private ContainerBuilder $container,
    ) {
    }

    public function getActions(): Generator
    {
        foreach ($this->container->findTaggedServiceIds(LogicExtension::ACTION_TAG) as $id => $tags) {
            $service = $this->container->getDefinition($id);
            if ($service->isAbstract()) {
                continue;
            }

            yield $id => $service;
        }
    }
}
