<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Reference;
use XCart\Bundle\LogicBundle\Decorator\Validator\Request\AssertValidator;
use XCart\Bundle\LogicBundle\DependencyInjection\Compiler\DataProvider\ActionDataProvider;

class CreateValidatorsPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $actionDataProvider = new ActionDataProvider($container);

        foreach ($actionDataProvider->getActions() as $id => $service) {
            $decoratorId = $id . '.decorator.validation.request_validator';
            $decorator = (new Definition(AssertValidator::class))
                ->setDecoratedService($id, null, 20)
                ->setArgument('$inner', new Reference($decoratorId . '.inner'))
                ->setArgument('$validator', new Reference('validator'))
                ->setArgument('$responseAssembler', new Reference('xcart.bundle.logic.decorator.validator.default_response_assembler'));

            $container->setDefinition($decoratorId, $decorator);
        }
    }
}
