<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use XCart\Bundle\LogicBundle\DependencyInjection\Compiler\DataProvider\ActionDataProvider;
use XCart\Bundle\LogicBundle\DependencyInjection\LogicExtension;
use XCart\Bundle\LogicBundle\Factory\Response\ResponseFactory;

class CreateResponseFactoriesPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $actionDataProvider = new ActionDataProvider($container);

        foreach ($actionDataProvider->getActions() as $id => $service) {
            $tag = $service->getTag(LogicExtension::ACTION_TAG);
            if (empty($tag[0]['response'])) {
                continue;
            }

            $serviceId = $id . '.factory.response';
            $service = (new Definition(ResponseFactory::class))
                ->setArgument('$className', $tag[0]['response']);

            $container->setDefinition($serviceId, $service);
        }
    }
}
