<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Reference;
use XCart\Bundle\LogicBundle\Decorator\Validator\Request\ClassNameValidator;
use XCart\Bundle\LogicBundle\DependencyInjection\Compiler\DataProvider\ActionDataProvider;
use XCart\Bundle\LogicBundle\DependencyInjection\LogicExtension;

class CreateClassNameValidatorsPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $actionDataProvider = new ActionDataProvider($container);

        foreach ($actionDataProvider->getActions() as $id => $service) {
            $tag = $service->getTag(LogicExtension::ACTION_TAG);
            if (empty($tag[0]['request'])) {
                continue;
            }

            $decoratorId = $id . '.decorator.validation.class_name';
            $decorator = (new Definition(ClassNameValidator::class))
                ->setDecoratedService($id, null, 10)
                ->setArgument('$inner', new Reference($decoratorId . '.inner'))
                ->setArgument('$className', $tag[0]['request'])
                ->setArgument('$responseAssembler', new Reference('xcart.bundle.logic.decorator.validator.default_response_assembler'));

            $container->setDefinition($decoratorId, $decorator);
        }
    }
}
