<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Decorator\Validator\Request;

use Symfony\Component\Validator\ConstraintViolationList;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\Decorator\Validator\Request\Assembler\Response\ResponseAssemblerInterface;
use XCart\Bundle\LogicBundle\Decorator\Validator\Request\Rule\PreRuleInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class RulesPreValidator implements ActionInterface
{
    /**
     * @param PreRuleInterface[] $subvalidators
     */
    public function __construct(
        private ActionInterface $inner,
        private iterable $subvalidators,
        private ResponseAssemblerInterface $responseAssembler,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        $violationList = new ConstraintViolationList();

        /** @var PreRuleInterface $subvalidator */
        foreach ($this->subvalidators as $subvalidator) {
            $violation = $subvalidator->check($request);
            if ($violation) {
                $violationList->add($violation);
            }
        }

        if (count($violationList) === 0) {
            return $this->inner->run($request);
        }

        return $this->responseAssembler->assemble($violationList);
    }
}
