<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Decorator\Validator\Request;

use Symfony\Component\Validator\ConstraintViolationList;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\Decorator\Validator\Request\Assembler\Response\ResponseAssemblerInterface;
use XCart\Bundle\LogicBundle\Decorator\Validator\Request\Rule\PostRuleInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\FailedResponseInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class RulesPostValidator implements ActionInterface
{
    /**
     * @param PostRuleInterface[] $subvalidators
     */
    public function __construct(
        private ActionInterface $inner,
        private iterable $subvalidators,
        private ResponseAssemblerInterface $responseAssembler,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        $response = $this->inner->run($request);
        if ($response instanceof FailedResponseInterface) {
            return $response;
        }

        $violationList = new ConstraintViolationList();

        /** @var PostRuleInterface $subvalidator */
        foreach ($this->subvalidators as $subvalidator) {
            $violation = $subvalidator->check($request, $response);
            if ($violation) {
                $violationList->add($violation);
            }
        }

        if (count($violationList) === 0) {
            return $response;
        }

        return $this->responseAssembler->assemble($violationList);
    }
}
