<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Decorator\Validator\Request\Rule\PreRule;

use Symfony\Component\Validator\ConstraintViolation;
use Symfony\Component\Validator\ConstraintViolationInterface;
use XCart\Bundle\LogicBundle\Decorator\Validator\Request\Rule\PreRuleInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestUserOwnerInterface;

class RoleAccessPreRule implements PreRuleInterface
{
    /**
     * @param string[] $roles
     */
    public function __construct(
        private array $roles,
    ) {
    }

    /**
     * @param RequestUserOwnerInterface $request
     */
    public function check(RequestInterface $request): ?ConstraintViolationInterface
    {
        if (!$request->getUser()) {
            return new ConstraintViolation(
                'User unauthenticated',
                null,
                ['user' => null],
                $request,
                'class',
                get_class($request)
            );
        }

        if (!array_intersect($request->getUser()->getRoles(), $this->roles)) {
            return new ConstraintViolation(
                sprintf(
                    'User %s has not any roles from this list %s',
                    $request->getUser()->getUserIdentifier(),
                    implode(', ', $this->roles),
                ),
                'User {user} has not any roles from this list {roles}',
                [
                    'user'  => $request->getUser()->getUserIdentifier(),
                    'roles' => $this->roles,
                ],
                $request->getUser(),
                'class',
                get_class($request->getUser())
            );
        }

        return null;
    }
}
