<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Decorator\Validator\Request;

use Symfony\Component\Validator\ConstraintViolation;
use Symfony\Component\Validator\ConstraintViolationList;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\Decorator\Validator\Request\Assembler\Response\ResponseAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class ClassNameValidator implements ActionInterface
{
    public function __construct(
        private ActionInterface $inner,
        private string $className,
        private ResponseAssemblerInterface $responseAssembler,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        if ($request instanceof $this->className) {
            return $this->inner->run($request);
        }

        $violationList = new ConstraintViolationList();
        $violationList->add(
            new ConstraintViolation(
                sprintf('Request has class %s instead %s', get_class($request), $this->className),
                'Request has class %s instead %s',
                [
                    'expected' => $this->className,
                    'actual'   => get_class($request),
                ],
                $request,
                'class',
                get_class($request)
            ),
        );

        return $this->responseAssembler->assemble($violationList);
    }
}
