<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Decorator\Validator\Request;

use Symfony\Component\Validator\Validator\ValidatorInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\Decorator\Validator\Request\Assembler\Response\ResponseAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class AssertValidator implements ActionInterface
{
    public function __construct(
        private ActionInterface $inner,
        private ValidatorInterface $validator,
        private ResponseAssemblerInterface $responseAssembler,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        $violationList = $this->validator->validate($request);

        if (count($violationList) === 0) {
            return $this->inner->run($request);
        }

        return $this->responseAssembler->assemble($violationList);
    }
}
