<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Decorator\Validator\Request\Assembler\Response;

use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Validator\ConstraintViolationInterface;
use Symfony\Component\Validator\ConstraintViolationListInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\Factory\Response\ResponseFactoryInterface;

class DefaultFailedResponseAssembler implements ResponseAssemblerInterface
{
    private const DEFAULT_TITLE = 'Validation failed';
    private const DEFAULT_TYPE = '/errors/validation';

    public function __construct(
        private ResponseFactoryInterface $responseFactory,
        private string $title = self::DEFAULT_TITLE,
        private string $type = self::DEFAULT_TYPE,
    ) {
    }

    public function assemble(ConstraintViolationListInterface $violationList): DefaultFailedResponse
    {
        /** @var DefaultFailedResponse $response */
        $response = $this->responseFactory->create();

        $response->setType($this->type)
            ->setTitle($this->title)
            ->setStatus(Response::HTTP_UNPROCESSABLE_ENTITY);

        $messages = [];
        /** @var ConstraintViolationInterface $violation */
        foreach ($violationList as $violation) {
            $messages[] = (string)$violation->getMessage();
        }

        $response->setDetail(implode(PHP_EOL, $messages));

        return $response;
    }
}
