<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Decorator\RequestEnricher\User;

use Symfony\Component\Security\Core\Security;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestUserOwnerInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class UserEnrichDecorator implements ActionInterface
{
    public function __construct(
        private ActionInterface $inner,
        private Security $security,
    ) {
    }

    /**
     * @param RequestUserOwnerInterface $request
     */
    public function run(RequestInterface $request): ResponseInterface
    {
        $request->setUser($this->security->getUser());

        return $this->inner->run($request);
    }
}
